diary
%% perform all the counterfactual analysis
model_simulation_import_tariff
model_simulation_export_tariff

%% obtain employment by province and sector in the baseline model
clear
load observed
emp=zeros(29,30);
for i=1:30
    emp=emp+china_pi_1(:,:,i).*low_skill(i)+china_pi_2(:,:,i).*high_skill(i);
end

%% import tariff change
load('results_import_tariff','w0','P')
nwage_change_import_tariff=round((1./(sum(w0(1:30,:)'.*emp,1)./sum(emp,1))'-1)*100,2)
nwage_change_import_tariff(end+1)=round(mean((1./(sum(w0(1:30,:)'.*emp,1)./sum(emp,1))'-1)*100),2)
price_change_import_tariff=round((1./P(1:30)-1)*100,2)
price_change_import_tariff(end+1)=round(mean((1./P(1:30)-1)*100),2)
rwage_change_import_tariff=round((1./(sum(w0(1:30,:)'.*emp,1)./sum(emp,1))'-1./P(1:30))*100,2)
rwage_change_import_tariff(end+1)=round(mean((1./(sum(w0(1:30,:)'.*emp,1)./sum(emp,1))'-1./P(1:30))*100),2)

%% export tariff change
load('results_export_tariff','w0','P')
nwage_change_export_tariff=round((1./(sum(w0(1:30,:)'.*emp,1)./sum(emp,1))'-1)*100,2)
nwage_change_export_tariff(end+1)=round(mean((1./(sum(w0(1:30,:)'.*emp,1)./sum(emp,1))'-1)*100),2)
price_change_export_tariff=round((1./P(1:30)-1)*100,2)
price_change_export_tariff(end+1)=round(mean((1./P(1:30)-1)*100),2)
rwage_change_export_tariff=round((1./(sum(w0(1:30,:)'.*emp,1)./sum(emp,1))'-1./P(1:30))*100,2)
rwage_change_export_tariff(end+1)=round(mean((1./(sum(w0(1:30,:)'.*emp,1)./sum(emp,1))'-1./P(1:30))*100),2)

%% report results
province_name=[""
""
"ӱʡ"
"ɽʡ"
"ɹ"
"ʡ"
"ʡ"
"ʡ"
"Ϻ"
"ʡ"
"㽭ʡ"
"ʡ"
"ʡ"
"ʡ"
"ɽʡ"
"ʡ"
"ʡ"
"ʡ"
"㶫ʡ"
"ʡ"
"ʡ"
""
"Ĵʡ"
"ʡ"
"ʡ"
"ʡ"
"ʡ"
"ຣʡ"
"Ļ"
"½ά"
"ƽ"
]

table(nwage_change_import_tariff,price_change_import_tariff,rwage_change_import_tariff,...
    nwage_change_export_tariff,price_change_export_tariff,rwage_change_export_tariff,'RowNames',province_name)
diary off