diary
%% perform all the counterfactual analysis
model_simulation_import_tariff
model_simulation_export_tariff

%% obtain employment by province and sector in the baseline model
clear
load observed
emp=zeros(29,30);
for i=1:30
    emp=emp+china_pi_1(:,:,i).*low_skill(i)+china_pi_2(:,:,i).*high_skill(i);
end

%% import tariff change
load('results_import_tariff','china_pi_1','china_pi_2','mighat_china1','mighat_china2','china_gdp','china_gdp_ori','P')
emp_new=zeros(29,30);
china_pi_1=china_pi_1.*mighat_china1;
china_pi_2=china_pi_2.*mighat_china2;
for i=1:30
    emp_new=emp_new+china_pi_1(:,:,i).*low_skill(i)+china_pi_2(:,:,i).*high_skill(i);
end

avg_wage_ori=sum(sum(china_gdp_ori))./sum(sum(emp));
avg_wage_pro_ori=sum(china_gdp_ori,1)./sum(emp,1);
theil_ori=sum(sum(emp,1).*avg_wage_pro_ori./sum(sum(emp))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp))./sum(sum(emp_new));
avg_wage_pro_new=sum(china_gdp,1)./sum(emp_new,1);
theil_new=sum(sum(emp_new,1).*avg_wage_pro_new./sum(sum(emp_new))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

nwage_change_import_tariff=round(theil_ori-theil_new,4);
nwage_initial_theil=round(theil_ori,4);
nwage_percent_import_tariff=round((theil_ori-theil_new)./theil_ori*100,1);

initial_price=[0.999999945
0.801308935
0.620697561
0.725945131
0.675605771
0.682159066
0.663056176
0.671662669
0.974217371
0.730109586
0.723100912
0.651750377
0.71169836
0.666190963
0.673712788
0.621383012
0.697849924
0.75450989
0.8689851
0.694331626
0.845142585
0.628808338
0.651987134
0.725559107
0.768235784
0.733669144
0.69722035
0.72429783
0.682682428
0.69949979
];

avg_wage_ori=sum(sum(china_gdp_ori,1)./initial_price')./sum(sum(emp));
avg_wage_pro_ori=sum(china_gdp_ori,1)./sum(emp,1)./initial_price';
theil_ori=sum(sum(emp,1).*avg_wage_pro_ori./sum(sum(emp))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp,1)./initial_price'./P(1:30)')./sum(sum(emp_new));
avg_wage_pro_new=sum(china_gdp,1)./sum(emp_new,1)./initial_price'./P(1:30)';
theil_new=sum(sum(emp_new,1).*avg_wage_pro_new./sum(sum(emp_new))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

rwage_change_import_tariff=round(theil_ori-theil_new,4);
rwage_initial_theil=round(theil_ori,4);
rwage_percent_import_tariff=round((theil_ori-theil_new)./theil_ori*100,1);
display(["finish computing the Theil index for import tariff changes"])

%% export tariff change
load('results_export_tariff','china_pi_1','china_pi_2','mighat_china1','mighat_china2','china_gdp','china_gdp_ori','P')
emp_new=zeros(29,30);
china_pi_1=china_pi_1.*mighat_china1;
china_pi_2=china_pi_2.*mighat_china2;
for i=1:30
    emp_new=emp_new+china_pi_1(:,:,i).*low_skill(i)+china_pi_2(:,:,i).*high_skill(i);
end

avg_wage_ori=sum(sum(china_gdp_ori))./sum(sum(emp));
avg_wage_pro_ori=sum(china_gdp_ori,1)./sum(emp,1);
theil_ori=sum(sum(emp,1).*avg_wage_pro_ori./sum(sum(emp))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp))./sum(sum(emp_new));
avg_wage_pro_new=sum(china_gdp,1)./sum(emp_new,1);
theil_new=sum(sum(emp_new,1).*avg_wage_pro_new./sum(sum(emp_new))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

nwage_change_export_tariff=round(theil_ori-theil_new,4);
nwage_initial_theil=round(theil_ori,4);
nwage_percent_export_tariff=round((theil_ori-theil_new)./theil_ori*100,1);

initial_price=[0.999999945
0.801308935
0.620697561
0.725945131
0.675605771
0.682159066
0.663056176
0.671662669
0.974217371
0.730109586
0.723100912
0.651750377
0.71169836
0.666190963
0.673712788
0.621383012
0.697849924
0.75450989
0.8689851
0.694331626
0.845142585
0.628808338
0.651987134
0.725559107
0.768235784
0.733669144
0.69722035
0.72429783
0.682682428
0.69949979
];

avg_wage_ori=sum(sum(china_gdp_ori,1)./initial_price')./sum(sum(emp));
avg_wage_pro_ori=sum(china_gdp_ori,1)./sum(emp,1)./initial_price';
theil_ori=sum(sum(emp,1).*avg_wage_pro_ori./sum(sum(emp))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp,1)./initial_price'./P(1:30)')./sum(sum(emp_new));
avg_wage_pro_new=sum(china_gdp,1)./sum(emp_new,1)./initial_price'./P(1:30)';
theil_new=sum(sum(emp_new,1).*avg_wage_pro_new./sum(sum(emp_new))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

rwage_change_export_tariff=round(theil_ori-theil_new,4);
rwage_initial_theil=round(theil_ori,4);
rwage_percent_export_tariff=round(rwage_change_export_tariff./rwage_initial_theil*100,1);

display(["finish computing the Theil index for export tariff changes"])

%% draw tables
initial_theil=[nwage_initial_theil;rwage_initial_theil];
change_import_tariff=[nwage_change_import_tariff;rwage_change_import_tariff];
percent_import_tariff=[nwage_percent_import_tariff;rwage_percent_import_tariff];
change_export_tariff=[nwage_change_export_tariff;rwage_change_export_tariff];
percent_export_tariff=[nwage_percent_export_tariff;rwage_percent_export_tariff];
label=["ʡݼ幤Theilָ";"ʡݼʵʹTheilָ"];
table(initial_theil,change_import_tariff,percent_import_tariff,change_export_tariff,percent_export_tariff,'RowNames',label)


diary off