diary
%% perform all the counterfactual analysis
model_simulation_import_tariff
model_simulation_export_tariff
model_simulation_import_tariff_nolabormove
model_simulation_export_tariff_nolabormove
%% obtain employment by province and sector in the baseline model
clear
load observed
emp_ori=china_pi_1(:,:,:).*repmat(permute(low_skill,[2 3 1]),[29 30 1])+china_pi_2(:,:,:).*repmat(permute(high_skill,[2 3 1]),[29 30 1]);

%% import tariff change
load('results_import_tariff','china_pay_1','china_pay_1_change','china_pay_2','china_pay_2_change','china_pi_1','china_pi_2','mighat_china1','mighat_china2','china_gdp','china_gdp_ori','P')
china_pi_1=china_pi_1.*mighat_china1;
china_pi_2=china_pi_2.*mighat_china2;
emp_new=china_pi_1(:,:,:).*repmat(permute(low_skill,[2 3 1]),[29 30 1])+china_pi_2(:,:,:).*repmat(permute(high_skill,[2 3 1]),[29 30 1]);

avg_wage_ori=sum(sum(china_gdp_ori))./sum(sum(sum(emp_ori)));
avg_wage_pro_ori=permute(sum(sum(china_pay_1+china_pay_2,1),2),[2 3 1])./permute(sum(sum(emp_ori,1),2),[2 3 1]);
theil_ori=sum(permute(sum(sum(emp_ori,1),2),[2 3 1]).*avg_wage_pro_ori./sum(sum(sum(emp_ori)))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp))./sum(sum(sum(emp_new)));
avg_wage_pro_new=permute(sum(sum(china_pay_1_change+china_pay_2_change,1),2),[2 3 1])./permute(sum(sum(emp_new,1),2),[2 3 1]);
theil_new=sum(permute(sum(sum(emp_new,1),2),[2 3 1]).*avg_wage_pro_new./sum(sum(sum(emp_new)))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

nwage_change_import_tariff=round(theil_ori-theil_new,4);
nwage_initial_theil=round(theil_ori,4);

initial_price=[0.999999945
0.801308935
0.620697561
0.725945131
0.675605771
0.682159066
0.663056176
0.671662669
0.974217371
0.730109586
0.723100912
0.651750377
0.71169836
0.666190963
0.673712788
0.621383012
0.697849924
0.75450989
0.8689851
0.694331626
0.845142585
0.628808338
0.651987134
0.725559107
0.768235784
0.733669144
0.69722035
0.72429783
0.682682428
0.69949979
];

avg_wage_ori=sum(sum(china_gdp_ori,1)./initial_price')./sum(sum(sum(emp_ori)));
avg_wage_pro_ori=permute(sum(sum(china_pay_1+china_pay_2,1)./repmat(initial_price',[1 1 30]),2),[2 3 1])./permute(sum(sum(emp_ori,1),2),[2 3 1]);
theil_ori=sum(permute(sum(sum(emp_ori,1),2),[2 3 1]).*avg_wage_pro_ori./sum(sum(sum(emp_ori)))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp,1)./initial_price'./P(1:30)')./sum(sum(sum(emp_new)));
avg_wage_pro_new=permute(sum(sum(china_pay_1_change+china_pay_2_change,1)./repmat(initial_price'.*P(1:30)',[1 1 30]),2),[2 3 1])./permute(sum(sum(emp_new,1),2),[2 3 1]);
theil_new=sum(permute(sum(sum(emp_new,1),2),[2 3 1]).*avg_wage_pro_new./sum(sum(sum(emp_new)))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

rwage_change_import_tariff=round(theil_ori-theil_new,4);
rwage_initial_theil=round(theil_ori,4);

display(["finish computing the Theil index for import tariff changes"])

%% export tariff change
load('results_export_tariff','china_pay_1','china_pay_1_change','china_pay_2','china_pay_2_change','china_pi_1','china_pi_2','mighat_china1','mighat_china2','china_gdp','china_gdp_ori','P')
china_pi_1=china_pi_1.*mighat_china1;
china_pi_2=china_pi_2.*mighat_china2;
emp_new=china_pi_1(:,:,:).*repmat(permute(low_skill,[2 3 1]),[29 30 1])+china_pi_2(:,:,:).*repmat(permute(high_skill,[2 3 1]),[29 30 1]);

avg_wage_ori=sum(sum(china_gdp_ori))./sum(sum(sum(emp_ori)));
avg_wage_pro_ori=permute(sum(sum(china_pay_1+china_pay_2,1),2),[2 3 1])./permute(sum(sum(emp_ori,1),2),[2 3 1]);
theil_ori=sum(permute(sum(sum(emp_ori,1),2),[2 3 1]).*avg_wage_pro_ori./sum(sum(sum(emp_ori)))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp))./sum(sum(sum(emp_new)));
avg_wage_pro_new=permute(sum(sum(china_pay_1_change+china_pay_2_change,1),2),[2 3 1])./permute(sum(sum(emp_new,1),2),[2 3 1]);
theil_new=sum(permute(sum(sum(emp_new,1),2),[2 3 1]).*avg_wage_pro_new./sum(sum(sum(emp_new)))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

nwage_change_export_tariff=round(theil_ori-theil_new,4);
nwage_initial_theil=round(theil_ori,4);

initial_price=[0.999999945
0.801308935
0.620697561
0.725945131
0.675605771
0.682159066
0.663056176
0.671662669
0.974217371
0.730109586
0.723100912
0.651750377
0.71169836
0.666190963
0.673712788
0.621383012
0.697849924
0.75450989
0.8689851
0.694331626
0.845142585
0.628808338
0.651987134
0.725559107
0.768235784
0.733669144
0.69722035
0.72429783
0.682682428
0.69949979
];

avg_wage_ori=sum(sum(china_gdp_ori,1)./initial_price')./sum(sum(sum(emp_ori)));
avg_wage_pro_ori=permute(sum(sum(china_pay_1+china_pay_2,1)./repmat(initial_price',[1 1 30]),2),[2 3 1])./permute(sum(sum(emp_ori,1),2),[2 3 1]);
theil_ori=sum(permute(sum(sum(emp_ori,1),2),[2 3 1]).*avg_wage_pro_ori./sum(sum(sum(emp_ori)))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp,1)./initial_price'./P(1:30)')./sum(sum(sum(emp_new)));
avg_wage_pro_new=permute(sum(sum(china_pay_1_change+china_pay_2_change,1)./repmat(initial_price'.*P(1:30)',[1 1 30]),2),[2 3 1])./permute(sum(sum(emp_new,1),2),[2 3 1]);
theil_new=sum(permute(sum(sum(emp_new,1),2),[2 3 1]).*avg_wage_pro_new./sum(sum(sum(emp_new)))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

rwage_change_export_tariff=round(theil_ori-theil_new,4);
rwage_initial_theil=round(theil_ori,4);

display(["finish computing the Theil index for export tariff changes"])

%% import tariff change without labor movements
load('results_import_tariff_nolabormove','china_pay_1','china_pay_1_change','china_pay_2','china_pay_2_change','china_pi_1','china_pi_2','mighat_china1','mighat_china2','china_gdp','china_gdp_ori','P')
china_pi_1=china_pi_1.*mighat_china1;
china_pi_2=china_pi_2.*mighat_china2;
emp_new=china_pi_1(:,:,:).*repmat(permute(low_skill,[2 3 1]),[29 30 1])+china_pi_2(:,:,:).*repmat(permute(high_skill,[2 3 1]),[29 30 1]);

avg_wage_ori=sum(sum(china_gdp_ori))./sum(sum(sum(emp_ori)));
avg_wage_pro_ori=permute(sum(sum(china_pay_1+china_pay_2,1),2),[2 3 1])./permute(sum(sum(emp_ori,1),2),[2 3 1]);
theil_ori=sum(permute(sum(sum(emp_ori,1),2),[2 3 1]).*avg_wage_pro_ori./sum(sum(sum(emp_ori)))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp))./sum(sum(sum(emp_new)));
avg_wage_pro_new=permute(sum(sum(china_pay_1_change+china_pay_2_change,1),2),[2 3 1])./permute(sum(sum(emp_new,1),2),[2 3 1]);
theil_new=sum(permute(sum(sum(emp_new,1),2),[2 3 1]).*avg_wage_pro_new./sum(sum(sum(emp_new)))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

nwage_change_import_tariff_nomove=round(theil_ori-theil_new,4);
nwage_initial_theil=round(theil_ori,4);

initial_price=[0.999999945
0.801308935
0.620697561
0.725945131
0.675605771
0.682159066
0.663056176
0.671662669
0.974217371
0.730109586
0.723100912
0.651750377
0.71169836
0.666190963
0.673712788
0.621383012
0.697849924
0.75450989
0.8689851
0.694331626
0.845142585
0.628808338
0.651987134
0.725559107
0.768235784
0.733669144
0.69722035
0.72429783
0.682682428
0.69949979
];

avg_wage_ori=sum(sum(china_gdp_ori,1)./initial_price')./sum(sum(sum(emp_ori)));
avg_wage_pro_ori=permute(sum(sum(china_pay_1+china_pay_2,1)./repmat(initial_price',[1 1 30]),2),[2 3 1])./permute(sum(sum(emp_ori,1),2),[2 3 1]);
theil_ori=sum(permute(sum(sum(emp_ori,1),2),[2 3 1]).*avg_wage_pro_ori./sum(sum(sum(emp_ori)))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp,1)./initial_price'./P(1:30)')./sum(sum(sum(emp_new)));
avg_wage_pro_new=permute(sum(sum(china_pay_1_change+china_pay_2_change,1)./repmat(initial_price'.*P(1:30)',[1 1 30]),2),[2 3 1])./permute(sum(sum(emp_new,1),2),[2 3 1]);
theil_new=sum(permute(sum(sum(emp_new,1),2),[2 3 1]).*avg_wage_pro_new./sum(sum(sum(emp_new)))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

rwage_change_import_tariff_nomove=round(theil_ori-theil_new,4);
rwage_initial_theil=round(theil_ori,4);

display(["finish computing the Theil index for import tariff changes without labor movements"])

%% export tariff change without labor movements
load('results_export_tariff_nolabormove','china_pay_1','china_pay_1_change','china_pay_2','china_pay_2_change','china_pi_1','china_pi_2','mighat_china1','mighat_china2','china_gdp','china_gdp_ori','P')
china_pi_1=china_pi_1.*mighat_china1;
china_pi_2=china_pi_2.*mighat_china2;
emp_new=china_pi_1(:,:,:).*repmat(permute(low_skill,[2 3 1]),[29 30 1])+china_pi_2(:,:,:).*repmat(permute(high_skill,[2 3 1]),[29 30 1]);

avg_wage_ori=sum(sum(china_gdp_ori))./sum(sum(sum(emp_ori)));
avg_wage_pro_ori=permute(sum(sum(china_pay_1+china_pay_2,1),2),[2 3 1])./permute(sum(sum(emp_ori,1),2),[2 3 1]);
theil_ori=sum(permute(sum(sum(emp_ori,1),2),[2 3 1]).*avg_wage_pro_ori./sum(sum(sum(emp_ori)))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp))./sum(sum(sum(emp_new)));
avg_wage_pro_new=permute(sum(sum(china_pay_1_change+china_pay_2_change,1),2),[2 3 1])./permute(sum(sum(emp_new,1),2),[2 3 1]);
theil_new=sum(permute(sum(sum(emp_new,1),2),[2 3 1]).*avg_wage_pro_new./sum(sum(sum(emp_new)))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

nwage_change_export_tariff_nomove=round(theil_ori-theil_new,4);
nwage_initial_theil=round(theil_ori,4);

initial_price=[0.999999945
0.801308935
0.620697561
0.725945131
0.675605771
0.682159066
0.663056176
0.671662669
0.974217371
0.730109586
0.723100912
0.651750377
0.71169836
0.666190963
0.673712788
0.621383012
0.697849924
0.75450989
0.8689851
0.694331626
0.845142585
0.628808338
0.651987134
0.725559107
0.768235784
0.733669144
0.69722035
0.72429783
0.682682428
0.69949979
];

avg_wage_ori=sum(sum(china_gdp_ori,1)./initial_price')./sum(sum(sum(emp_ori)));
avg_wage_pro_ori=permute(sum(sum(china_pay_1+china_pay_2,1)./repmat(initial_price',[1 1 30]),2),[2 3 1])./permute(sum(sum(emp_ori,1),2),[2 3 1]);
theil_ori=sum(permute(sum(sum(emp_ori,1),2),[2 3 1]).*avg_wage_pro_ori./sum(sum(sum(emp_ori)))./avg_wage_ori.*log(avg_wage_pro_ori./avg_wage_ori));

avg_wage_new=sum(sum(china_gdp,1)./initial_price'./P(1:30)')./sum(sum(sum(emp_new)));
avg_wage_pro_new=permute(sum(sum(china_pay_1_change+china_pay_2_change,1)./repmat(initial_price'.*P(1:30)',[1 1 30]),2),[2 3 1])./permute(sum(sum(emp_new,1),2),[2 3 1]);
theil_new=sum(permute(sum(sum(emp_new,1),2),[2 3 1]).*avg_wage_pro_new./sum(sum(sum(emp_new)))./avg_wage_new.*log(avg_wage_pro_new./avg_wage_new));

rwage_change_export_tariff_nomove=round(theil_ori-theil_new,4);
rwage_initial_theil=round(theil_ori,4);

display(["finish computing the Theil index for export tariff changes without labor movements"])

%% draw tables
initial_theil=[nwage_initial_theil;rwage_initial_theil];
change_tariff=[nwage_change_import_tariff+nwage_change_export_tariff;rwage_change_import_tariff+rwage_change_export_tariff];
percent_tariff=round(change_tariff./initial_theil*100,1);
change_tariff_nomove=[nwage_change_import_tariff_nomove+nwage_change_export_tariff_nomove;rwage_change_import_tariff_nomove+rwage_change_export_tariff_nomove];
percent_tariff_nomove=round(change_tariff_nomove./initial_theil*100,1);
label=["ʡݼ幤Theilָ";"ʡݼʵʹTheilָ"];
table(initial_theil,change_tariff,percent_tariff,change_tariff_nomove,percent_tariff_nomove,'RowNames',label)


diary off