* CAUTION!!!: ABSOLUTE path set here
global OUTPATH "$PATH\结果存放"

log using "LOG", replace

* tabV1: summary statistics 
* tab2: baseline results & proxy 
* tabVII1: robustness (1)
* tabVII2: robustness (2) 

**# import data
use "dataFinal.dta", clear

**# prepare
destring year, replace
encode city, gen(icity)
order icity, after(city)
xtset icity year

replace IFDI = log(IFDI)
replace IFDIproxy = log(IFDIproxy) 
replace IFDIht = log(IFDIht)
replace IFDIg7 = log(IFDIg7)
replace IFDIother = log(IFDIother)

replace fin = log(fin)
replace passenger = log(passenger)
replace freight = log(freight)
replace sciEx = log(sciEx)
replace university = log(university)
replace professor = log(professor)

winsor2 Y*, replace cuts(1 99)
winsor2 IFDI*, replace cuts(1 99)

global X1 "Vshr1 Vshr2 fin"
global X2 "passenger freight"
global X3 "sciEx university professor"


**# tabV1: summary statistics

outreg2 using "$OUTPATH/tabV1", excel replace sum(log) keep(Y1_7 IFDI IFDIproxy $X1 $X2 $X3) dec(2)


**# tab2: baseline regress: use Y1_7

reghdfe Y1_7 IFDI, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tab2", keep(IFDI) excel dec(4) addtext("ctrl", "N", "city FE", "Y", "year FE", "Y") replace 

reghdfe Y1_7 IFDI $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tab2", keep(IFDI) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y")


**# tab2: endogeneity: FDI proxy

reghdfe Y1_7 IFDIproxy, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tab2", keep(IFDIproxy) excel dec(4) addtext("ctrl", "N", "city FE", "Y", "year FE", "Y")

reghdfe Y1_7 IFDIproxy $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tab2", keep(IFDIproxy) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y")


**# tabVII1: robustness: use Y2_7 

reghdfe Y2_7 IFDIproxy $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabVII1", keep(IFDIproxy) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y") replace


**# tabVII1: robustness: use Y1_5 Y1_9 (threshold 0.5 & 0.9)

reghdfe Y1_5 IFDIproxy $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabVII1", keep(IFDIproxy) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y")

reghdfe Y1_9 IFDIproxy $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabVII1", keep(IFDIproxy) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y")

**# tabVII1: robustness: ordinary & processing & value-added

reghdfe Y1_yb IFDIproxy $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabVII1", keep(IFDIproxy) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y")

reghdfe Y1_jg IFDIproxy $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabVII1", keep(IFDIproxy) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y")

reghdfe Y1_va IFDIproxy $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabVII1", keep(IFDIproxy) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y")


**# tabVII2: robustness: use fractional response model (correlated RE)
egen mIFDIproxy = mean(IFDIproxy), by(city)
egen mVshr1 = mean(Vshr1), by(city)
egen mVshr2 = mean(Vshr2), by(city)
egen mfin = mean(fin), by(city)
egen mpassenger = mean(passenger), by(city)
egen mfreight = mean(freight), by(city)
egen msciEx = mean(sciEx), by(city)
egen muniversity = mean(university), by(city)
egen mprofessor = mean(professor), by(city)

xtgee Y1_7 IFDIproxy $X1 $X2 $X3 i.year m*, family(binomial) link(logit) vce(robust)
margins, dydx(_all) post
outreg2 using "$OUTPATH/tabVII2", keep(IFDIproxy) excel dec(4) addtext("ctrl", "Y", "city FE", "N", "year FE", "Y", "CRE", "Y") replace
drop m*


**# tabVII2: robustness: prov x year FE (implicitly drop "直辖市")

encode prov, gen(iprov)

reghdfe Y1_7 IFDIproxy $X1 $X2 $X3, absorb(city i.iprov#i.year) cluster(city)
outreg2 using "$OUTPATH/tabVII2", keep(IFDIproxy) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "N", "prov_year", "Y") append 































