* CAUTION!!!: ABSOLUTE path set here
global OUTPATH "$PATH\结果存放"

log using "LOG", replace
* tabVII2: robustness add GVC controls

**# import data
use "dataFinal_GVC.dta", clear


**# prepare
destring year, replace
encode city, gen(icity)
order icity, after(city)
xtset icity year

replace IFDI = log(IFDI)
replace IFDIproxy = log(IFDIproxy) 
replace IFDIht = log(IFDIht)
replace IFDIg7 = log(IFDIg7)
replace IFDIother = log(IFDIother)

replace fin = log(fin)
replace passenger = log(passenger)
replace freight = log(freight)
replace sciEx = log(sciEx)
replace university = log(university)
replace professor = log(professor)

winsor2 Y*, replace cuts(1 99)
winsor2 IFDI* U* D*, replace cuts(1 99)

global X1 "Vshr1 Vshr2 fin"
global X2 "passenger freight"
global X3 "sciEx university professor"


**# GVC location 

* GVC location -> (IFDI -> Y1_7) ?

reghdfe Y1_7 IFDIproxy $X1 $X2 $X3 span, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabVII2", keep(IFDIproxy span) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y")

reghdfe Y1_7 IFDIproxy $X1 $X2 $X3 posM, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabVII2", keep(IFDIproxy posM) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y")

reghdfe Y1_7 IFDIproxy $X1 $X2 $X3 posX, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabVII2", keep(IFDIproxy posX) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y")

reghdfe Y1_7 IFDIproxy $X1 $X2 $X3 span posM posX, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabVII2", keep(IFDIproxy span posM posX) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y") sortvar(IFDIproxy span posM posX)





















