

/*******************************************************************************
*
*	Statistical Management System and Statistical Data Quality
*
*******************************************************************************/	

	
	clear all                 //Remove everything from the memory, refresh.
    cap log close             //Close any open log file.
    set more off              //Show the result all at once.
    set rmsg on
	//ssc install asdoc       //安装外部命令
	//ssc install outreg2     //安装外部命令
	
	gl  root = "C:\Users\lfore\Desktop\代码整理\2024-01107_数据"   //设定工作路径
	cd $root
	

	gl dofiles="$root\2024-01107_程序代码"
	gl working_data="$root\2024-01107_使用数据"
	gl tables="$root\2024-01107_日志文件"
   

	*----------------- 指标含义 -----------------*	
/*	注：（1）本文基准回归探究法官过去1年经验积累的影响，对应变量后缀标识为"_1"
		（2）稳健性检验中探究法官过去3年经验积累的影响，对应变量后缀标识为"_3"
		（3）变量后缀“_1”与“_3”仅反应计算区间不同，变量定义一致。例如：
	         judge_type_num_1（过去1年同类案件审理数）与judge_type_num_3（过去3年同类案件审理数）。
		     为避免冗余，此处仅介绍后缀“_1”的变量含义。
			
	法官特征相关
	judge_type_num_1:过去1年同类案件审理数（取对数）；
	judge_other_year_1：过去1年不同类案件审理数（取对数）；
	judge_type_case_change_1_r：过去1年同类案件改判率；
	judge_other_case_change_1_r：过去1年不同类案件改判率；
	r_case_appeal_change_p_1：过去1年原告上诉占所有案件的比例
	r_case_appeal_change_d_1：过去1年被告上诉占所有案件的比例
	r_case_appeal_p_1：过去1年原告上诉被改判占原告上诉案件的比例 
	r_case_appeal_d_1：过去1年被告上诉被改判占被告上诉案件的比例
		
	法官审理本类案件平均
	claim_amount_type_ave_1：过去1年审理的本类案件平均诉求金额（取对数）；
	defendant_present_type_ave_1：过去1年本类案件被告到庭占比；
	defendant_lawyer_type_ave_1：过去1年审理的本类案件被告聘请律师占比；
	plaintiff_lawyer_type_ave_1：过去1年审理的本类案件原告聘请律师占比；
	case_judge_num_type_ave_1：过去1年审理的本类案件平均参与审理法官数量； 
	lncited_num_type_ave_1：过去1年审理的本类案件平均引用法条条数； 
	lncited_words_type_ave_1：过去1年审理的本类案件平均引用法条字数；   
	plaintiff_entity_type_ave_1：过去1年审理的本类案件原告是非自然人占比；
	defendant_entity_type_ave_1：过去1年审理的本类案件被告是非自然人占比；
		
	法官审理其他类案件平均
	lnclaim_amount_other_ave_1：过去1年审理的其他类案件平均诉求金额（取对数）；
	defendant_present_other_ave_1：过去1年其他类案件被告到庭占比；
	defendant_lawyer_other_ave_1：过去1年审理的其他类案件被告聘请律师占比；
	plaintiff_lawyer_other_ave_1：过去1年审理的其他类案件原告聘请律师占比；
	case_judge_num_other_ave_1：过去1年审理的其他类案件平均参与审理法官数量；
	lncited_num_other_ave_1：过去1年审理的其他类案件平均引用法条条数； 
	lncited_words_other_ave_1：过去1年审理的其他类案件平均引用法条字数；  
	plaintiff_entity_other_ave_1：过去1年审理的其他类案件原告是非自然人占比；   
	defendant_entity_other_ave_1：过去1年审理的其他类案件被告是非自然人占比； 
	
	案件特征相关
	lnclaim_amount：本案诉求金额对数；
	defendant_present：被告是否到庭；
	defendant_lawyer：被告是否有律师；
	plaintiff_lawyer：原告是否有律师；
	case_judge_num：审理本案法官数量
	lncited_num：本案判决书引用法条条数
	lncited_words：本案判决书引用法条字数
	appeal：本案是否上诉进入二审
	plaintiff_entity：原告是否上诉
	defendant_entity：被告是否上诉
	reversed：上诉案件是否被改判
	reversed_degree：上诉案件被改判程度
	argument_strength：判决书说理充分程度
	lntrial_gap_days：二审与一审时间间隔天数对数
	court_level：法院层级
	judge_work_year_addup：法官审理当前案件时工作年数
	judge_year：本案判决年份（年份固定效应）
	case_type：本案案件类型（案件类型固定效应）
	judge_id：案件对应的法官id（法官固定效应）
	case_id：案件id（聚类层级）
	weight：审理本案的法官数量倒数
	
	城市特征相关
	lnave_wage：职工平均工资对数；
	second_emp_r：第二产业从业人员比重；
	third_emp_r：第三产业从业人员比重； 
	lnind_firm_num：工业企业个数对数；
	lnpopulation：总人口数对数；  
	lntechexp：科学技术支出对数； 
	court_reform：是否实施人财物统管改革；
	ave_law_cost：城市律师费负担
    */
	
	*本文涉及的变量较多，首先对变量进行分组，并生成全局变量
	global 法官特征_1  lnjudge_type_num_1  lnjudge_other_year_1   judge_type_case_change_1_r  judge_other_case_change_1_r
	global 本类案件平均_1 lnclaim_amount_type_ave_1 defendant_present_type_ave_1 defendant_lawyer_type_ave_1 plaintiff_lawyer_type_ave_1 case_judge_num_type_ave_1 lncited_num_type_ave_1 lncited_words_type_ave_1   plaintiff_entity_type_ave_1   defendant_entity_type_ave_1  
	global 其他类案件平均_1 lnclaim_amount_other_ave_1 defendant_present_other_ave_1 defendant_lawyer_other_ave_1 plaintiff_lawyer_other_ave_1 case_judge_num_other_ave_1 lncited_num_other_ave_1 lncited_words_other_ave_1  plaintiff_entity_other_ave_1   defendant_entity_other_ave_1  
	
	global 法官特征_3  lnjudge_type_num_3 	lnjudge_other_year_3  judge_type_case_change_3_r  judge_other_case_change_3_r  
	global 本类案件平均_3  lnclaim_amount_type_ave_3 defendant_present_type_ave_3 defendant_lawyer_type_ave_3 plaintiff_lawyer_type_ave_3 case_judge_num_type_ave_3 lncited_num_type_ave_3 lncited_words_type_ave_3  plaintiff_entity_type_ave_3  defendant_entity_type_ave_3
	global 其他类案件平均_3 lnclaim_amount_other_ave_3 defendant_present_other_ave_3 defendant_lawyer_other_ave_3 plaintiff_lawyer_other_ave_3 case_judge_num_other_ave_3 lncited_num_other_ave_3 lncited_words_other_ave_3  plaintiff_entity_other_ave_3  defendant_entity_other_ave_3  
	
	global 案件特征 lnclaim_amount defendant_present defendant_lawyer plaintiff_lawyer case_judge_num    lncited_num    lncited_words  plaintiff_entity defendant_entity 
	
	global 城市特征 lnave_wage  second_emp_r  third_emp_r  lnind_firm_num lnpopulation  lntechexp court_reform
	

******************# 表1 修正样本选择偏误前后的回归结果 #************************	
	
	*表1： 第（1）（2）（3）列
	use "$working_data\法官人力资本研究数据.dta" ,clear
	
	reghdfe reversed   $法官特征_1  $城市特征 ,   absorb  (  i.judge_year      i.case_type  i.judge_id   )  vce(cluster case_id)
	est store m1
	reghdfe reversed  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $城市特征    ,absorb  (i.judge_year      i.case_type  i.judge_id   )  vce(cluster case_id)
	est store m2
	reghdfe reversed  $法官特征_1   $本类案件平均_1  $其他类案件平均_1   $案件特征  $城市特征   ,absorb  (i.judge_year      i.case_type  i.judge_id  )  vce(cluster case_id)
	est store m3
	
	outreg2 [m1 m2 m3 ] using  $tables\table1-1.xls,            ///
			stat(coef se) bdec(4)  title("Model") replace       ///
            keep(lnjudge_type_num_1  lnjudge_other_year_1)   ///
			addtext(judge_year FE, YES, case_type FE, YES, judge_id FE, YES) 
    	   
			
	*表1：第（4）（5）列	
	use "$working_data\法官人力资本研究数据.dta" ,clear
	
	probit appeal  ave_law_cost  $法官特征_1  $本类案件平均_1  $其他类案件平均_1   $案件特征  $城市特征     i.judge_year      i.case_type  i.judge_id   //第一阶段
	est store m4
	estimate store First
	predict y_hat, xb     //获得预测值
	gen pdf = normalden(y_hat)  
	gen cdf = normal(y_hat)  
	gen imr = pdf/cdf    //计算imr
	reghdfe reversed  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征 imr  ,absorb( i.judge_year    i.case_type   i.judge_id )   vce(cluster case_id)    //第二阶段
	est store m5
	
	outreg2 [m4 m5] using  $tables\table1-2.xls,            ///
			stat(coef se) bdec(4)  title("Model") replace       ///
            keep(ave_law_cost  lnjudge_type_num_1  lnjudge_other_year_1 imr)   ///
			addtext(judge_year FE, YES, case_type FE, YES, judge_id FE, YES)
			

	
***********************# 表2 异质性分析 #**************************************		
	use "$working_data\法官人力资本研究数据.dta" ,clear
	
	probit appeal    ave_law_cost  $法官特征_1  $本类案件平均_1  $其他类案件平均_1   $案件特征  $城市特征     i.judge_year      i.case_type  i.judge_id    
	estimate store First
	predict y_hat, xb    //获得预测值
	gen pdf = normalden(y_hat)  
	gen cdf = normal(y_hat)  
	gen imr = pdf/cdf    //计算imr
	**法院层级
	//第1列结果_中级法院
	reghdfe reversed  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征 imr  if  court_level=="中级法院" ,absorb( i.judge_year       i.case_type   i.judge_id )  vce(cluster  case_id)
	est store m1
	//第2列结果_基层法院
	reghdfe reversed  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征 imr  if  court_level=="基层法院" ,absorb( i.judge_year       i.case_type   i.judge_id )  vce(cluster  case_id)
	est store m2
	
	**案件复杂性
	//第3列结果_独任庭
	reghdfe reversed  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征 imr  if  case_judge_num==1 ,absorb( i.judge_year      i.case_type   i.judge_id )   vce(cluster  case_id  )
	est store m3
	//第4列结果_合议庭
	reghdfe reversed  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征 imr  if  case_judge_num>1,absorb( i.judge_year      i.case_type   i.judge_id )  vce(cluster  case_id)
	est store m4
	
	
	outreg2 [m1 m2 m3 m4 ] using  $tables\table2.xls,            ///
		stat(coef se) bdec(4)  title("Model") replace       ///
        keep(lnjudge_type_num_1  lnjudge_other_year_1 imr)   ///
		addtext(judge_year FE, YES, case_type FE, YES, judge_id FE, YES)	
		
	
***********************# 表3 法官经验积累对上诉的影响 #*************************	
	use "$working_data\法官人力资本研究数据.dta" ,clear
	//第1列_当事人是否上诉
	reghdfe appeal  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征 $城市特征  ,absorb( i.judge_year    i.case_type   i.judge_id )   vce(cluster  case_id)
	est store m1
	//第2列_原告是否上诉
	reghdfe plaintiff_appeal  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征    ,absorb( i.judge_year     i.case_type   i.judge_id )   vce(cluster  case_id)
	est store m2
	//第3列_被告是否上诉
	reghdfe defendant_appeal  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征    ,absorb( i.judge_year     i.case_type   i.judge_id )  vce(cluster   case_id)
	est store m3

	outreg2 [m1 m2 m3  ] using  $tables\table3.xls,            ///
		stat(coef se) bdec(4)  title("Model") replace       ///
        keep(lnjudge_type_num_1  lnjudge_other_year_1)   ///
		addtext(judge_year FE, YES, case_type FE, YES, judge_id FE, YES)		
	
	
***********************# 表4 法官经验积累对改判结果的影响 #*********************	
	use "$working_data\法官人力资本研究数据.dta" ,clear
	
	probit appeal    ave_law_cost  $法官特征_1  $本类案件平均_1  $其他类案件平均_1   $案件特征  $城市特征     i.judge_year      i.case_type  i.judge_id    
	estimate store First
	predict y_hat, xb    //获得预测值
	gen pdf = normalden(y_hat)  
	gen cdf = normal(y_hat)  
	gen imr = pdf/cdf    //计算imr
	//第1列_原告上诉
	reghdfe reversed  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征 imr if  plaintiff_appeal==1 ,absorb( i.judge_year      i.case_type   i.judge_id )   vce(cluster  case_id  )
	est store m1
	//第2列_被告上诉
	reghdfe reversed  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征  imr if  defendant_appeal==1 ,absorb( i.judge_year     i.case_type   i.judge_id )   vce(cluster  case_id  )
	est store m2
	
	outreg2 [m1 m2 ] using  $tables\table4.xls,            ///
		stat(coef se) bdec(4)  title("Model") replace       ///
        keep(lnjudge_type_num_1  lnjudge_other_year_1 )   ///
		addtext(judge_year FE, YES, case_type FE, YES, judge_id FE, YES)		
	
***********************# 表5 不同经历对改判结果的影响 #*************************		
	use "$working_data\法官人力资本研究数据.dta" ,clear
	
	//过去1年原告上诉占所有案件的比例与过去1年被告上诉占所有案件的比例
	probit appeal    ave_law_cost  r_case_appeal_p_1 r_case_appeal_d_1  $法官特征_1  $本类案件平均_1  $其他类案件平均_1   $案件特征  $城市特征     i.judge_year    i.case_type  i.judge_id              
	estimate store First
	predict y_hat, xb   //获得预测值
	gen pdf = normalden(y_hat)  
	gen cdf = normal(y_hat)  
	gen imr = pdf/cdf  //计算imr
	//第1列_原告上诉
	reghdfe reversed  r_case_appeal_p_1 r_case_appeal_d_1  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征 imr if plaintiff_appeal==1  ,absorb( i.judge_year      i.case_type   i.judge_id )   vce(cluster case_id)
	est store m1
	//第2列_被告上诉
	reghdfe reversed  r_case_appeal_p_1 r_case_appeal_d_1  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征 imr if defendant_appeal==1  ,absorb( i.judge_year      i.case_type   i.judge_id )   vce(cluster case_id)
	est store m2
	
	drop  y_hat  pdf  cdf  imr  //删除中间变量，继续运行下一组结果
	
	//过去1年原告上诉被改判占原告上诉案件的比例与过去1年被告上诉被改判占原告上诉案件的比例
	probit appeal    ave_law_cost r_case_appeal_change_p_1 r_case_appeal_change_d_1    $法官特征_1  $本类案件平均_1  $其他类案件平均_1   $案件特征  $城市特征     i.judge_year    i.case_type  i.judge_id               //Heckman两阶段的第一阶段回归，这里的r可加可不加，看需不需要控制异方差问题。
	estimate store First
	predict y_hat, xb   //获得预测值
	gen pdf = normalden(y_hat)  
	gen cdf = normal(y_hat)  
	gen imr = pdf/cdf  //计算imr
	//第3列_原告上诉
	reghdfe reversed  r_case_appeal_change_p_1 r_case_appeal_change_d_1   $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征 imr if plaintiff_appeal==1  ,absorb( i.judge_year      i.case_type   i.judge_id )   vce(cluster case_id)
	est store m3
	//第4列_被告上诉
	reghdfe reversed  r_case_appeal_change_p_1 r_case_appeal_change_d_1   $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征 imr if defendant_appeal==1  ,absorb( i.judge_year      i.case_type   i.judge_id )   vce(cluster case_id)
	est store m4
	
	outreg2 [m1 m2 m3 m4] using  $tables\table5.xls,            ///
		stat(coef se) bdec(4)  title("Model") replace       ///
        keep(ave_law_cost  r_case_appeal_p_1 r_case_appeal_d_1  ave_law_cost r_case_appeal_change_p_1 r_case_appeal_change_d_1  lnjudge_type_num_1  lnjudge_other_year_1 )   ///
		addtext(judge_year FE, YES, case_type FE, YES, judge_id FE, YES)		
	
	
				
******************# 附录IV 表IV1 稳健性检验 #***********************************		
	use "$working_data\法官人力资本研究数据.dta" ,clear
	//首先计算第2列的结果_过去3年的经验影响
	probit appeal    ave_law_cost  $法官特征_3  $本类案件平均_3  $其他类案件平均_3   $案件特征  $城市特征     i.judge_year    i.case_type  i.judge_id  
	estimate store First
	predict y_hat, xb   //获得预测值
	gen pdf = normalden(y_hat)  
	gen cdf = normal(y_hat)  
	gen imr = pdf/cdf  //计算imr
	reghdfe reversed  $法官特征_3  $本类案件平均_3  $其他类案件平均_3  $案件特征  $城市特征  imr , absorb(  i.judge_year     i.case_type   i.judge_id )   vce(cluster case_id)
	est store m2
	
	
	drop  y_hat  pdf  cdf  imr  //删除中间变量，继续运行下一组结果
	
	
	//计算第3列的结果_加入权重
	probit appeal    ave_law_cost  $法官特征_1  $本类案件平均_1  $其他类案件平均_1   $案件特征  $城市特征     i.judge_year    i.case_type  i.judge_id [iweight=weight]     
	estimate store First
	predict y_hat, xb   //获得预测值
	gen pdf = normalden(y_hat)  
	gen cdf = normal(y_hat)  
	gen imr = pdf/cdf  //计算imr
	reg reversed  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征 imr i.judge_year      i.case_type   i.judge_id  [iweight=weight], vce(cluster case_id)   //注：reghdfe不支持iweight，因而直接使用reg估计
	est store m3
	
	drop  y_hat  pdf  cdf  imr  //删除中间变量，继续运行下一组结果
	
	//计算第1，4，5列的结果
	probit appeal    ave_law_cost  $法官特征_1  $本类案件平均_1  $其他类案件平均_1   $案件特征  $城市特征     i.judge_year      i.case_type  i.judge_id    
	estimate store First
	predict y_hat, xb    //获得预测值
	gen pdf = normalden(y_hat)  
	gen cdf = normal(y_hat)  
	gen imr = pdf/cdf    //计算imr
	//第1列结果_改判程度
	reghdfe reversed_degree  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征  imr   ,absorb( i.judge_year    i.case_type   i.judge_id )   vce(cluster case_id)      
	est store m1
	//第4列结果_用2015年及以后的数据回归
	reghdfe reversed  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征  imr  if judge_year>=2015 ,absorb( i.judge_year       i.case_type   i.judge_id )   vce(cluster case_id)
	est store m4
	//第5列结果_加入一审与二审的时间间隔
	reghdfe reversed  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征  imr lntrial_gap_days  ,absorb( i.judge_year     i.case_type   i.judge_id )   vce(cluster case_id)
	est store m5
	
	//第6列结果_使用改判程度
	reghdfe argument_strength  $法官特征_1  $本类案件平均_1  $其他类案件平均_1  $案件特征  $城市特征    ,absorb( i.judge_year     i.case_type   i.judge_id )   vce(cluster  case_id)
	est store m6

	outreg2 [m1 m2 m3 m4 m5 m6] using  $tables\附表IV1.xls,            ///
		stat(coef se) bdec(4)  title("Model") replace       ///
        keep(lnjudge_type_num_1  lnjudge_other_year_1 lnjudge_type_num_3  lnjudge_other_year_3 imr)   ///
		addtext(judge_year FE, YES, case_type FE, YES, judge_id FE, YES)
	
	



*************************# 附录VI 表A1 描述性统计 #**************************
	use "$working_data\法官人力资本研究数据.dta" ,clear
	
	*尽管在回归分析中除了虚拟变量和比值外都取对数，但在为了更清晰地展示数据，在描述性统计中展示没有取对数的数据
	**由于某些数据原始数值较大，进行单位转化
	gen claim_amount_10k=claim_amount/10000    //单位万元
	gen ave_wage_10k=ave_wage/10000              //单位万元
	gen population_10k=population/10           //单位万
	gen techexp_bn=techexp/10000               //单位亿元
	
	*描述性统计结果
	
	asdoc sum  reversed   judge_type_num_1 	judge_other_year_1        judge_type_case_change_1_r  judge_other_case_change_1_r    judge_type_num_3 	judge_other_year_3        judge_type_case_change_3_r  judge_other_case_change_3_r  claim_amount_10k defendant_present defendant_lawyer plaintiff_lawyer case_judge_num    cited_num  cited_words  plaintiff_entity  defendant_entity  ave_wage_10k   second_emp_r  third_emp_r    ind_firm_num population_10k   techexp_bn  court_reform  argument_strength    ave_law_cost,  replace save($tables\附表A1.doc) title("描述性统计结果")
	
	
	
	
	
	
***********# 附录VI 表A2 法官工作年数与案件特征的相关性分析 #***********
	
	use "$working_data\法官人力资本研究数据.dta" ,clear
	
	asdoc pwcorr judge_work_year_addup claim_amount defendant_present defendant_lawyer plaintiff_lawyer plaintiff_entity defendant_entity, replace save($tables\附表A2.doc) title("相关系数矩阵")   //注：代码会输出两两相关的系数，但附录VI表A2仅关注输出结果第一列的相关系数

	


