	
	
********************************************************************************

* Description: "对口帮扶的信用援助效应——来自城投债发行定价的证据"

********************************************************************************\
	cap log close
	log using "logfile", replace

	clear all
	
	cd "E:\复现材料\信用帮扶"
	
	//被解释变量 spread
	
	//解释变量 dkbf
	
	//债券发行特征控制变量
	global ctrl_bond size maturity ifop ifgua 
	
	//发债主体层面控制变量
	global ctrl_issuer asset lev roa turnover 
	
	//地区层面控制变量
	global ctrl_city gdp second revenue transfer finance
	
*================================三、(三) 描述性统计============================


	use bond_data, clear
	
	*表1 变量的统计描述
 	tabstat spread dkbf $ctrl_bond $ctrl_issuer $ctrl_city, stats(N mean sd min p50 max) col(s) f(%10.3f)


	
*================================四、(一)  基准回归=============================

	use bond_data, clear
	
	*表2 基准回归结果
	eststo m1: reghdfe spread dkbf, absorb(issuerid provid#year bondrate) cluster(cityid)
		
	eststo m2: reghdfe spread dkbf $ctrl_bond $ctrl_issuer, absorb(issuerid provid#year bondrate) cluster(cityid)

	eststo m3: reghdfe spread dkbf $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid)

	local models m1 m2 m3
	esttab `models', b(%6.4f) se(%6.4f) nogap compress  ///
	   star(* 0.1 ** 0.05 *** 0.01)  ///
	   scalar(N r2_a) replace         ///
	   order(dkbf $ctrl_bond $ctrl_issuer $ctrl_city) 
    

	
*================================四、(二)  影响机理分析=========================

	
	*1.对口帮扶政策对发债主体信用评价的影响
	//本部分采用城投公司发行主体-年份层面的面板数据展开分析
	use issuer_data, clear
	
	*表3 对口帮扶政策与发债主体信用评级的检验结果
	eststo m1: reghdfe cfrate dkbf $ctrl_issuer $ctrl_city, absorb(issuerid provid#year) cluster(cityid)
	
	local models m1
	esttab `models', b(%6.4f) se(%6.4f) nogap compress  ///
	   star(* 0.1 ** 0.05 *** 0.01)  ///
	   scalar(N r2_a) replace         ///
	   order(dkbf $ctrl_issuer $ctrl_city) 
	   
	   
	*2.对政府隐性担保能力机制的检验
	//本部分采用西部地级市-年份层面的面板数据展开分析
	use city_data, clear
	
	*表4  政府隐性担保能力机制的检验结果
	eststo m1: reghdfe growth dkbf $ctrl_city, absorb(cityid provid#year) cluster(cityid) 
	
	eststo m2: reghdfe land dkbf $ctrl_city, absorb(cityid provid#year) cluster(cityid) 
	
	eststo m3: reghdfe infrastructure dkbf $ctrl_city, absorb(cityid provid#year) cluster(cityid) 
	
	eststo m4: reghdfe industryinv dkbf $ctrl_city, absorb(cityid provid#year) cluster(cityid) 
	
	eststo m5: reghdfe eduinv dkbf $ctrl_city, absorb(cityid provid#year) cluster(cityid) 
	
	eststo m6: reghdfe capatent dkbf $ctrl_city, absorb(cityid provid#year) cluster(cityid) 
	
	local models m1 m2 m3 m4 m5 m6
	esttab `models' , b(%6.4f) se(%6.4f) nogap compress  ///
	   star(* 0.1 ** 0.05 *** 0.01)  ///
	   scalar(N r2_a) replace         ///
	   order(dkbf $ctrl_city) 		
	
	
	*3.对政府隐性担保意愿机制的检验
	//本部分数据与基准回归一致
	use bond_data, clear
	
	*表5  政府隐性担保意愿机制的检验结果
	eststo m1: reghdfe spread dkbf replaceratio dkbf_replaceratio $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	
	*$ctrl_city中已经包含transfer单独项，因此不在回归中另外加入
	eststo m2: reghdfe spread dkbf dkbf_transfer $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 

	local models m1 m2
	esttab  `models', b(%6.4f) se(%6.4f) nogap compress  ///
	   star(* 0.1 ** 0.05 *** 0.01)  ///
	   scalar(N r2_a) replace         ///
	   order( dkbf dkbf_replaceratio dkbf_transfer replaceratio transfer $ctrl_bond $ctrl_issuer ) 	
	
	
*========================四、(三)  针对对口帮扶的地区配对策略的讨论=============
	
	use bond_data, clear
	
	*附表III1  被帮扶地区特征与政策效果发挥的检验结果
	*由于mgdp mrevenue mfinloan均为地级市在政策实施前一年（即2016年）的数据，非时变，因此单独项被固定效应吸收了
	eststo m1: reghdfe spread dkbf mgdp dkbf_mgdp $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	
	eststo m2: reghdfe spread dkbf mrevenue dkbf_mrevenue $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	
	eststo m3: reghdfe spread dkbf mfinloan dkbf_mfinloan $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
		
	local models m1 m2 m3
	esttab  `models' , b(%6.4f) se(%6.4f) nogap compress  ///
	   star(* 0.1 ** 0.05 *** 0.01)  ///
	   scalar(N r2_a) replace         ///
	   order(dkbf dkbf_mgdp dkbf_mrevenue dkbf_mfinloan mgdp mrevenue mfinloan $ctrl_issuer $ctrl_issuer $ctrl_city) 
	
	
	*附表III2  提供帮扶地区特征与政策效果的检验结果
	eststo m1: reghdfe spread dkbf_prov dkbf_city $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	test _b[dkbf_prov] = _b[dkbf_city]
	
	eststo m2: reghdfe spread dkpf_pergdp1 dkpf_pergdp0 $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	test _b[dkpf_pergdp1] = _b[dkpf_pergdp0]
	
	eststo m3: reghdfe spread dkbf_revenue1 dkbf_revenue0 $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	test _b[dkbf_revenue1] = _b[dkbf_revenue0]
	
	eststo m4: reghdfe spread dkbf_cost1 dkbf_cost0 $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	test _b[dkbf_cost1] = _b[dkbf_cost0]
	
	*post被年份固定效应吸收了
	eststo m5: reghdfe spread dkspread post dkspread_post $ctrl_bond $ctrl_issuer $ctrl_city if treat==1, absorb(issuerid provid#year bondrate) cluster(cityid)
	
	local models m1 m2 m3 m4 m5
	esttab  `models', b(%6.4f) se(%6.4f) nogap compress  ///
	   star(* 0.1 ** 0.05 *** 0.01)  ///
	   scalar(N r2_a) replace         ///
	   order(dkbf_prov dkbf_city dkpf_pergdp1 dkpf_pergdp0 dkbf_revenue1 dkbf_revenue0 dkbf_cost1 dkbf_cost0 dkspread post dkspread_post $ctrl_bond $ctrl_issuer $ctrl_city) 

	  
*========================四、(四)  针对如何更好地释放政策效果的讨论=============

	use bond_data, clear
	
	*表6  政策效果优化的检验结果
	eststo m1: reghdfe spread dkbf default dkbf_default $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	
	eststo m2: reghdfe spread dkbf debtratio dkbf_debtratio $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	 
	eststo m3: reghdfe spread dkbf_baidu1 dkbf_baidu0 $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	test _b[dkbf_baidu1] = _b[dkbf_baidu0]
	
	eststo m4: reghdfe spread dkbf_pop1 dkbf_pop0 $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	test _b[dkbf_pop1] = _b[dkbf_pop0]

	local models m1 m2 m3 m4 
	esttab  `models', b(%6.4f) se(%6.4f) nogap compress  ///
	   star(* 0.1 ** 0.05 *** 0.01)  ///
	   scalar(N r2_a) replace         ///
	   order(dkbf default dkbf_default debtratio dkbf_debtratio dkbf_baidu1 dkbf_baidu0 dkbf_pop1 dkbf_pop0 $ctrl_bond $ctrl_issuer $ctrl_city) 

	  
	  
*==============================五、稳健性检验===================================
	 
*========================五、(一)  平行趋势检验 ================================

	use bond_data, clear
	
	*图2 平行趋势检验; 也是附图1
	reghdfe spread pre_4 pre3 pre2 current post1 post2 post3 post4 $ctrl_bond $ctrl_issuer $ctrl_city year, absorb(issuerid provid#year bondrate) cluster(cityid) 
	
		coefplot, ///
		   keep(pre_4 pre3 pre2 year current post1 post2 post3 post4) color(gs3) ///
		   order(pre_4 pre3 pre2 year current post1 post2 post3 post4)   ///
		   yline(0, lwidth(vthin)lpattern(solid) lcolor(black))         ///
		   coeflabels(pre_4 = "<=-4" ///
		   pre3 = "-3" ///
		   pre2 = "-2"             ///
		   year = "-1"             ///
		   current = "0"           ///
		   post1  = "1"            ///
		   post2  = "2"            ///
		   post3  = "3"  		   ///
		   post4  = "4" )          ///
		   vertical ///
		   ytitle("系数") citop ciopts(recast(rcap) lcolor(gs10) lpattern(dash))  ///
		   xtitle("政策时点") levels(90) omitted ///
		   ylabel(-3.0(0.5)1.5, format(%7.2f) angle(0) nogrid axis(1)) ///
		   graphregion(color(white)) 
	
*========================五、(二)  排除对定价机制扭曲的担忧 ====================
	
	use bond_data, clear
	
	*附表IV1 对口帮扶政策与债券一二级价差的检验结果
	eststo m1: reghdfe op dkbf $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid)

	local models m1 
	esttab `models', b(%6.4f) se(%6.4f) nogap compress  ///
	   star(* 0.1 ** 0.05 *** 0.01)  ///
	   scalar(N r2_a) replace         ///
	   order(dkbf $ctrl_bond $ctrl_issuer $ctrl_city) 	
	
	
*========================附录中的其他稳健性检验 ================================
	//测算匹配权重_weight，运行此部分代码得到匹配权重_weight的测算结果
		use bond_data, clear
		drop _weight
		duplicates drop cityid, force
		psmatch2 idkbf gdp2016 revenue2016 poverty, neighbor(1) ate logit common ties  
		keep cityid _weight 
		sort cityid		
		save _weight, replace 
	
	use bond_data, clear
	drop _weight
	merge m:1 cityid using _weight
	
	*附表IV2  稳健性检验：内生性问题
	eststo m1: reghdfe spread dkbf $ctrl_bond $ctrl_issuer $ctrl_city trend_gpd trend_poverty, absorb(issuerid provid#year bondrate) cluster(cityid)

	eststo m2: reghdfe spread dkbf $ctrl_bond $ctrl_issuer $ctrl_city if _weight!=., absorb(issuerid provid#year bondrate) cluster(cityid)	

	local models m1 m2
	esttab `models', b(%6.4f) se(%6.4f) nogap compress  ///
	   star(* 0.1 ** 0.05 *** 0.01)  ///
	   scalar(N r2_a) replace         ///
	   order(dkbf $ctrl_bond $ctrl_issuer $ctrl_city) 	
	 
	*附图IV1 安慰剂检验
/*
    use bond_data,clear
	permute dkbf beta = _b[dkbf] se = _se[dkbf] df = e(df_r), reps(1000) rseed(123)  ///
	saving("simulations.dta", replace): reghdfe spread dkbf $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
*/

	use "simulations.dta", clear
	gen t_value = beta / se
	gen p_value = 2 * ttail(df, abs(beta/se))
	
	twoway (scatter p_value beta, msymbol(smcircle_hollow) mcolor(black)) (kdensity beta,yaxis(2) lp(solid)) , ///
		   title("") ///
		   xlabel(-1.2 "-1.2" -1.0 "-1.0" -0.5 "-0.5" 0.0 "0.0" 0.5 "0.5",format(%7.1f) angle(0)) ///
		   ylabel(0(0.2)1, format(%7.1f) angle(0) nogrid axis(1)) ///
		   ylabel(0(2)8, format(%7.1f) angle(0)  nogrid axis(2)) ///
		   xtitle("估计系数") ///
		   ytitle("P" "值" ,orientation(horizontal) axis(1)) ///
		   ytitle("系" "数" "核" "密" "度" "分" "布",orientation(horizontal)  axis(2)) ///
		   xline(0, lwidth(0.2) lp(dash))  ///
		   xline(-1.0964, lwidth(0.3) lp(solid)) ///
		   yline(0.1,lwidth(0.2) lp(dash)) ///
		   legend(label(1 "估计系数") label( 2 "核密度分布")) ///
		   plotregion(style(none)) /// 
		   graphregion(color(white)) 	
	
	
	use bond_data, clear
	
	*附表IV3  稳健性检验：替换估计模型
	*行业乘年份固定效应
	eststo m1: reghdfe spread dkbf $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year ind##year bondrate) cluster(cityid) keepsin
	
	*异方差稳健标准误
	eststo m2: reghdfe spread dkbf $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) vce(robust)
	
	*对标准误在地区与年份层面进行双重聚类调整
	eststo m3: vce2way reghdfe spread dkbf $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid year)
	
	*对标准误在发行主体层面进行聚类调整
	eststo m4: reghdfe spread dkbf $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(issuerid) 
			
	local models m1 m2 m3 m4
	esttab  `models' , b(%6.4f) se(%6.4f) nogap compress  ///
	   star(* 0.1 ** 0.05 *** 0.01)  ///
	   scalar(N r2_a) replace         ///
	   order(dkbf $ctrl_bond $ctrl_issuer $ctrl_city) 
	
	
	*附表IV4  稳健性检验：替换被解释变量与改变样本期间
	*替换被解释变量
	eststo m1: reghdfe spread1 dkbf $ctrl_bond $ctrl_issuer $ctrl_city, absorb(issuerid provid#year bondrate) cluster(cityid) 
	
	*样本期间：2015-2021
	eststo m2: reghdfe spread dkbf $ctrl_bond $ctrl_issuer $ctrl_city if year>=2015, absorb(issuerid provid#year bondrate) cluster(cityid) 
	
	*样本期间：2012-2019
	eststo m3: reghdfe spread dkbf $ctrl_bond $ctrl_issuer $ctrl_city if year<=2019, absorb(issuerid provid#year bondrate) cluster(cityid) 
	
	local models m1 m2 m3
	esttab  `models' , b(%6.4f) se(%6.4f) nogap compress  ///
	   star(* 0.1 ** 0.05 *** 0.01)  ///
	   scalar(N r2_a) replace         ///
	   order(dkbf $ctrl_bond $ctrl_issuer $ctrl_city) 

	log close
