 
 **************************************************
 **                                              **
 **        环境规制与家庭收入CHNS数据整理        **
 **                                              **
 **************************************************
 
 clear
 
 global path "E:\OneDrive\workingpaper\environmental_regulation_and_human_capital_accumulation"
 cd $path\results
 
 use $path/data/家庭经济机制检验.dta,clear
 
 global ctrl "age2 edu2 marital_state hhsize"
 
 global mis "treat post citycode IDind year provcd age age2 edu2 marital_state hhsize"
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 
 ************************************
 **    表5 家庭经济机制检验结果    **
 ************************************
 
 *是否有工作
 reghdfe job c.treat#c.post $ctrl,a(provcd#year citycode IDind) cluster(citycode#year)
 est store x1
 
 *个人工资
 reghdfe lnwage c.treat#c.post $ctrl if job==1,a(provcd#year citycode IDind) cluster(citycode#year)
 est store x2
 
 duplicates drop hhid year,force
 *家庭人均收入
 reghdfe lnhhinc_pc c.treat#c.post $ctrl,a(provcd#year citycode hhid) cluster(citycode#year)
 est store x3
 
 *家庭医疗支出
 reghdfe medical2 c.treat#c.post $ctrl,a(provcd#year citycode hhid) cluster(citycode#year)
 est store x4
 
 *家庭营养摄入
 reghdfe nutrition c.treat#c.post $ctrl,a(provcd#year citycode hhid) cluster(citycode#year)
 est store x5
 
 *家庭耐用电器数量
 reghdfe dianqi c.treat#c.post $ctrl,a(provcd#year citycode hhid) cluster(citycode#year)
 est store x6
 
 outreg2 [x1 x2 x3 x4 x5 x6] using 家庭经济机制检验,excel bracket e(N_full) se dec(3) replace
 
 
 
 
 ****************************************
 **    表VI1 家庭经济机制描述性统计    **
 ****************************************
 
 use $path/data/家庭经济机制检验.dta,clear
 
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 sum job lnwage treat post age2 edu2 marital_state
 
 duplicates drop hhid year,force
 
 sum lnhhinc_pc medical2 nutrition dianqi hhsize
 