* CAUTION!!!: ABSOLUTE path set here
global OUTPATH "$PATH\结果存放"

log using "LOG", replace

* fig1: aggregate dynamic of CAT 
* tab1: CAT spatial distribution, top/tail-10 cities  
* fig3: aggregate dynamic of ordinary/processing/value-added CAT 
* figIV1: aggregate dynamic of IFDI & CAT (see excel file)
* figIV2: IFDI comparison of top/tail-10 cities 
* figIV3: correlation of IFDI & CAT 
* tabIII1: CAT & economic development 

**# time-spatial CAT

* fig 1: simple mean, by year
use "dataMech1.dta", clear
destring year, replace
winsor2 Y*, cuts(1 99) replace
keep city year Y1_7
collapse (mean) Y1_7 (semean) sder = Y1_7, by(year) // "fig_excel.xlsx" too
generate up = Y1_7 + 1.96 * sder 
generate lw = Y1_7 - 1.96 * sder 
twoway (rcap up lw year) (connected Y1_7 year), xlabel(2000(1)2009) xtitle("") legend(off) // manual edit
graph save "$OUTPATH/fig1", replace

* tab 1: city level, top/tail
use "dataMech1.dta", clear
destring year, replace
winsor2 Y*, cuts(1 99) replace
keep city year Y1_7 Y1_yb Y1_jg Y1_va 
collapse (mean) Y1_7 Y1_yb Y1_jg Y1_va, by(city)
sort Y1_7
keep if inrange(_n, 1, 10) | inrange(_n, 272, 281)
generate aux = _n 
replace aux = -aux if aux > 10
sort aux 
export excel using "$OUTPATH\tab1.xlsx", firstrow(variables) replace


**# Y1_jg & Y1_yb & Y1_va, macro trend

* fig 3: simple mean, ordianry/processing/value-added 
use "dataMech1.dta", clear
destring year, replace
winsor2 Y*, cuts(1 99) replace
keep city year Y1_jg Y1_yb Y1_va  
collapse (mean) Y1_jg Y1_yb Y1_va, by(year)
twoway (connected Y1_yb year) (connected Y1_jg year) (connected Y1_va year), xlabel(2000(1)2009)  // manual edit
graph save "$OUTPATH/fig3", replace


**# figIV2: compare top/tail-10 cities' IFDI 

use "dataMech1.dta", clear
destring year, replace
keep year city IFDI

// top/tail-10 Y (after winsor 99)
keep if (city == "武汉市" | city ==  "天津市" | city ==  "烟台市" | city ==  "珠海市" | city ==  "成都市" | city ==  "南京市" | city ==  "上海市" | city ==  "广州市" | city ==  "大连市" | city ==  "青岛市") | (city ==  "雅安市" | city ==  "池州市'" | city ==  "朔州市" | city ==  "临汾市" | city ==  "辽源市" | city == "平凉市" | city == "益阳市" | city == "松原市" | city == "驻马店市" | city == "张家界市") 
generate grp = (city == "武汉市" | city ==  "天津市" | city ==  "烟台市" | city ==  "珠海市" | city ==  "成都市" | city ==  "南京市" | city ==  "上海市" | city ==  "广州市" | city ==  "大连市" | city ==  "青岛市")
label define grpLbl 1 "：跃迁程度高" 0 "：跃迁程度低"
label values grp grpLbl
keep if year >= 2000 & year <= 2009
replace IFDI = log(IFDI)
mkdensity IFDI, over(grp) // manual edit
graph save "$OUTPATH/figIV2", replace


**# figIV3: correlation of (IFDI & dS) - Y

use "dataMech1.dta", clear
keep city year Y1_7 IFDI
replace IFDI = log(IFDI)
winsor2 IFDI, cuts(1 99) trim replace
keep if Y1_7 != . & IFDI != .

binsreg Y1_7 IFDI, absorb(city year) nbins(50) polyreg(1) xtitle(`"{fontface "宋体":外商直接投资}"') ytitle(`"{fontface "宋体":比较优势跃迁程度}"')
// manual edit
graph save "$OUTPATH/figIV3", replace


**# regression of Y -> GDP

use "dataMech1.dta", clear
keep prov city year Y1_*
destring year, replace
merge 1:1 prov city year using "cityPanel_c.dta"

keep prov city year Y1_* GDP-life
encode city, gen(icity)
xtset icity year
replace GDPpc = log(GDPpc)
replace GDP = log(GDP)

* tab III1: economic development

reghdfe GDPpc L5.Y1_7, absorb(city year) cluster(city)
outreg2 using "$OUTPATH\tabIII1", dec(4) excel addtext("city FE", "Y", "year FE", "Y") replace

reghdfe GDP L5.Y1_7, absorb(city year) cluster(city)
outreg2 using "$OUTPATH\tabIII1", dec(4) excel addtext("city FE", "Y", "year FE", "Y")
















