* CAUTION!!!: ABSOLUTE path set here
global OUTPATH "$PATH\结果存放"

log using "LOG", replace
* tab3: mechanism of input structure

**# import data
use "dataMech1.dta", clear


**# prepare
destring year, replace
encode city, gen(icity)
order icity, after(city)
xtset icity year

replace IFDI = log(IFDI)
replace IFDIproxy = log(IFDIproxy) 
replace IFDIht = log(IFDIht)
replace IFDIg7 = log(IFDIg7)
replace IFDIother = log(IFDIother)

replace fin = log(fin)
replace passenger = log(passenger)
replace freight = log(freight)
replace sciEx = log(sciEx)
replace university = log(university)
replace professor = log(professor)

winsor2 Y*, replace cuts(1 99)
winsor2 IFDI*, replace cuts(1 99)

global X1 "Vshr1 Vshr2 fin"
global X2 "passenger freight"
global X3 "sciEx university professor"

replace dS = log(1 + dS)
winsor2 dS, cuts(1 99) replace



**# tab3: mechanism: IFDI -> dS & dS -> Y1

reghdfe dS IFDIproxy $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tab3", keep(IFDIproxy) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y") replace

reghdfe Y1_7 dS $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tab3", keep(dS) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y") 


**# tab3: mechanism: G7 & non-G7 IFDI

reghdfe Y1_7 IFDIg7 $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tab3", keep(IFDIg7) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y")

reghdfe Y1_7 IFDIother $X1 $X2 $X3, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tab3", keep(IFDIother) excel dec(4) addtext("ctrl", "Y", "city FE", "Y", "year FE", "Y") sortvar(IFDIproxy dS IFDIg7 IFDIother)












